function [pixelValues,xIndex,yIndex] = getRegion(inputImage,coordinatesOfDots,regionSize)
% This functions find regions of interests around the found dots by any
% detector
%
% Input :
%   - inputImage : input image
%   - coordinatesOfDots : two dimensional matrix with x and y-coordinates for coordinates of found points
%   - regionSize : size of the region (image patch) considered to fit a
%   Gaussian
% Output:
%   - list of Xoordinates, Ycoordinates and pixelsValues of image patches
%
% Author: Vladimir Curic (vladacuric@gmail.com), 2015-01-26

[r,c] = size(inputImage);

xIndex = round(coordinatesOfDots(1));
yIndex = round(coordinatesOfDots(2));

rangeX = round(xIndex);
rangeY = round(yIndex);

if (xIndex>=regionSize+1 && xIndex<=r-regionSize-1) && (yIndex>=regionSize+1 && yIndex<=c-regionSize-1)
    
    % if (regionSize<xIndex && xIndex<r-regionSize) && (regionSize<yIndex && yIndex<c-regionSize)
    %     rangeX = (round(xIndex-regionSize)):(round(xIndex+regionSize));
    %     rangeY = (round(yIndex-regionSize)):(round(yIndex+regionSize));
    
    pixelValues = inputImage((round(xIndex)-regionSize):(round(xIndex)+regionSize),(floor(yIndex)-regionSize):(floor(yIndex)+regionSize));
    % end
else
    pixelValues = [];
end

end
%end




