% SMeagol runinputfile, created 22-Sep-2016 15:12:09.
% a note on units: SMeagol does not know about units, and so the user is
% charged with using consistent units of length, time, and diffusion
% constants (units of length^2/time).
%% trj
% ----------------------------------------------------------------------- %
% trj: information about the input data.
trj.reactionFile='./tmp_6323593/reactions.txt';
trj.trajectoryFile='./tmp_6323593/trajectories.txt';
trj.degradedName='-1';
trj.timeScale=1;
trj.voxelSize=20;
trj.speciesNames{1}='P';
trj.D=1e+06;
% ----------------------------------------------------------------------- %
%% output
% ----------------------------------------------------------------------- %
% output: what to output, and where.
output.resultFile='SMresult.mat';
output.writeTifMovie=true;
output.plotTifMovie=false;
output.showPhotons=false;
output.showEmitters=false;
output.plotTrj=false;
output.movieLength=10000;
output.maxFrames=10000;
output.plotTrjZRange=[ -1000        1000];
output.movieFormat='tiff';
output.movieOptsImwrite = {};
% ----------------------------------------------------------------------- %
%% sample
% ----------------------------------------------------------------------- %
% sample: parameters describing illumination and image capture. SMeagol
% basically assumes that illumination and aquisition coincide, but
% continuous illumination can be modeled by an appropriate choice of
% photophysics-parameters.
sample.dt=0.01;
sample.tE=0.001;
% ----------------------------------------------------------------------- %
%% activation
% ----------------------------------------------------------------------- %
% activation: parameters describing the fluorophore activation process.
activation.type='SM_photoActivation_instant';
% ----------------------------------------------------------------------- %
%% baseIntensity
% ----------------------------------------------------------------------- %
% baseIntensity: every fluorescent group in the simulation has a basic
% emission intensity (photons/time) during illumination, which can vary
% from molecule to molecule, as determined at activation by these
% parameters.
baseIntensity.intensity=1e+05;
baseIntensity.type='SM_activationIntensity_uniform';
% ----------------------------------------------------------------------- %
%% photophys
% ----------------------------------------------------------------------- %
% photophys: parameters describing the dynamics of blinking and bleaching
% in terms of a Markov process (independent of the diffusive states
% described by the input trajectories).
photophys.bleach_time=Inf;
photophys.type='SM_fluo_only_bleach';
% ----------------------------------------------------------------------- %
%% psf
% ----------------------------------------------------------------------- %
% psf: parameters to simulate the microscope point-spread-function, i.e.,
% the (stochastic) map from the position of a fluorophore as it emits a
% photon to the position on the camera chip at which that photon is
% detected.
psf.type='SM_psf_GibsonLanni_680nm_NA149';
% ----------------------------------------------------------------------- %
%% camera
% ----------------------------------------------------------------------- %
% camera: these parameters describe a) The region of interest (ROI), i.e.,
% the size, shape, and location of the region imaged by the camera, and b)
% the noise properties of the EMCCD chip.
% (a) is described in terms of the size and number of active camera pixels,
% plus a linear transformation of simulated coordinates x to
% camera-centered coordinates y, given by y = (voxelsize)*A*x+b, where A is
% a 3*3 matrix, and b is a 3*1 vector. 
% (b) is parameterized in terms of the offset, readout noise (standard
% deviation), and EM gain (average number of photons per camera count). We
% use the model described in the Mortensen et al. (Nat Meth 7, 377–381,
% 2010, doi: 10.1038/nmeth.1447).
camera.alpha=0.05;
camera.offset=500;
camera.sigmaReadout=4;
camera.pixLength=80;
camera.xrange_px=300;
camera.yrange_px=30;
camera.A(1,:)=[1           0           0];
camera.A(2,:)=[0           1           0];
camera.A(3,:)=[0           0           1];
camera.b=[ 13000        1250         0]'; %(note transpose!)
% ----------------------------------------------------------------------- %
%% background
% ----------------------------------------------------------------------- %
% background: parameters to describe how the noisy image background is to
% be generated.
background.photons_per_pixel=1;
background.type='SM_bg_constant';
% ----------------------------------------------------------------------- %
